local function connectElevators(self)
	for k = 1,8,1 do
		if self.User[k-1] ~= 0 then
			table.insert(self.Link, GetObject(self.User[k-1]))
		end
	end
	self.State = 2
end

local function clawOnLinkedElevator(link)
	local claw = GetClaw()
	for _,elevator in ipairs(link) do
		if elevator:IsBelow(claw) then
			return true
		end
	end
	return false
end

local function startLinkedElevators(link)
	for _,elevator in ipairs(link) do
		if elevator.State ~= 0 then
			elevator.State = 1
		end
	end
end

function main(self)
	local claw = GetClaw()

	if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.Link = {}
		connectElevators(self)
		self.State = 1
	end

	if self.State == 1 and claw:InMinMax(self) then
		if clawOnLinkedElevator(self.Link) then
			startLinkedElevators(self.Link)
			self.attempts = Attempt()
			self.State = 2
		end
	end

	-- Reset if Claw dies:
	if self.State == 2 and Attempt() > self.attempts then
		self.State = 1
	end

end